//##############################################################
//
//	VideoMainCWnd.cpp
//
//##############################################################

#include "stdafx.h"
#include "SpeedDome.h"
#include "VideoMainCWnd.h"
#include "CapSetup.h"
#include "vfw.h"
#include "Preset.h"
#include "Comm.h"
#include "Misc.h"
#include "GlobalVar.h"

/* Macro to swap two values */
#define SWAP(x,y)   ((x)^=(y)^=(x)^=(y))
#define MAKEMPOINT(l)                   (*((POINTS *)&(l)))

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVideoMainCWnd

CVideoMainCWnd::CVideoMainCWnd()
{
}

CVideoMainCWnd::~CVideoMainCWnd()
{
}


BEGIN_MESSAGE_MAP(CVideoMainCWnd, CWnd)
	//{{AFX_MSG_MAP(CVideoMainCWnd)
	ON_WM_PARENTNOTIFY()
	ON_WM_MOUSEACTIVATE()
	//}}AFX_MSG_MAP
	ON_COMMAND(IDM_C_CAPTUREVIDEO,OnCapturevideo)
	ON_COMMAND(IDM_O_VIDEOFORMAT,OnCapVideoFormat)
	ON_COMMAND(IDM_O_VIDEOSOURCE,OnCapVideoFormat)
	ON_COMMAND(IDM_VDO_SAVEFRAME,OnCapVideoSaveFrame)
	//-----------------------------------------------------
	ON_COMMAND(IDM_VDO_PREVIEW,OnCapVideoPreview)
	ON_COMMAND(IDM_VDO_OVERLAY,OnCapVideoOverlay)
	//-----------------------------------------------------
	ON_COMMAND(IDM_VDO_CAPTUREFRAME,OnCapVideoCaptureFrame)

	ON_UPDATE_COMMAND_UI_RANGE(	IDM_VDO_DRIVER0,IDM_VDO_DRIVER9, OnUpdateCapVideoDriver)
	//----------------------------------------------------------------------------------
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVideoMainCWnd message handlers

//###############################################################
//	OnCapVideoFormat()
//###############################################################
void	CVideoMainCWnd::OnCapVideoFormat()
{
capDlgVideoFormat(G_hWndVideo);
}


//###############################################################
//	OnUpdateCapVideoDriver()
//###############################################################
void	CVideoMainCWnd::OnUpdateCapVideoDriver(CCmdUI* pCmdUI)
{
UINT    uIndex;
//-----------------
UINT	uI;
UINT    uError ;
HMENU   hMenu;

uIndex=pCmdUI->m_nID-IDM_VDO_DRIVER0;

// Try connecting to the capture driver
if (uError = capDriverConnect(G_hWndVideo, uIndex) ) 
	{
    gbHaveHardware = TRUE;
    gwDeviceIndex = uIndex;
	}
else 
	{
    gbHaveHardware = FALSE;
    gbLive = FALSE;
    gbOverlay = FALSE;
	}

// Get the capabilities of the capture driver
capDriverGetCaps(G_hWndVideo, &gCapDriverCaps, sizeof(CAPDRIVERCAPS)) ;

// Get the settings for the capture window
capGetStatus(G_hWndVideo, &gCapStatus , sizeof(gCapStatus));

// Check the appropriate driver in the Options menu
hMenu = ::GetMenu (m_hWnd);
for (uI = 0; uI < gDriverCount; uI++) 
	{
    CheckMenuItem (hMenu, IDM_VDO_DRIVER0 + uI, 
            MF_BYCOMMAND | ((uIndex == uI) ? MF_CHECKED : MF_UNCHECKED));
	} 

// set the preview rate (units are millisecs)
capPreviewRate(G_hWndVideo, gbHaveHardware ? 33 : 0); 
capPreviewScale(G_hWndVideo,TRUE);

// set live/overlay to default
VideoCapSetLive(gbLive);
VideoCapSetOverlay(gbOverlay);

}

//#############################################################
//	VideoCapSetLive(BOOL bLive)
//#############################################################
void	CVideoMainCWnd::VideoCapSetLive(BOOL bLive)
{
capPreview(G_hWndVideo, bLive);

::CheckMenuItem(::GetMenu(m_hWnd), IDM_VDO_PREVIEW,
    MF_BYCOMMAND | (bLive ? MF_CHECKED : MF_UNCHECKED));

gbLive = bLive;

if (bLive == TRUE) 
    VideoCapSetOverlay(FALSE);
}

//#############################################################
//	VideoCapSetLive(BOOL bLive)
//#############################################################
void	CVideoMainCWnd::VideoCapSetOverlay(BOOL bOverlay)
{
if (!gCapDriverCaps.fHasOverlay) 
	{
    ::CheckMenuItem(::GetMenu(m_hWnd), IDM_VDO_OVERLAY,
        MF_BYCOMMAND | MF_UNCHECKED);
    gbOverlay = FALSE;
    return;
	}

capOverlay(G_hWndVideo, bOverlay);

::CheckMenuItem(::GetMenu(m_hWnd), IDM_VDO_OVERLAY,
    MF_BYCOMMAND | (bOverlay ? MF_CHECKED : MF_UNCHECKED));

gbOverlay = bOverlay;

if (bOverlay == TRUE)
    VideoCapSetLive(FALSE);

}

//###############################################################
//	OnCCapturevideo() 
//###############################################################
void	CVideoMainCWnd::OnCapturevideo() 
{
	// TODO: Add your command handler code here

CCapSetup	y_CapSetupDlg;
y_CapSetupDlg.DoModal();

}

//###############################################################
//	OnCapVideoSource()
//###############################################################
void	CVideoMainCWnd::OnCapVideoSource()
{
capDlgVideoSource(G_hWndVideo);
}

//###############################################################
//	OnCapVideoPreview()
//###############################################################
void	CVideoMainCWnd::OnCapVideoPreview()
{
capGetStatus( G_hWndVideo,&gCapStatus,sizeof(CAPSTATUS) );
VideoCapSetLive(!gCapStatus.fLiveWindow);
}

//###############################################################
//	OnCapVideoOverlay()
//###############################################################
void	CVideoMainCWnd::OnCapVideoOverlay()
{
capGetStatus( G_hWndVideo,&gCapStatus,sizeof(CAPSTATUS) );
VideoCapSetOverlay(!gCapStatus.fOverlayWindow);
}

//###############################################################
//	OnCapVideoCaptureFrame()
//###############################################################
void	CVideoMainCWnd::OnCapVideoCaptureFrame()
{
VideoCapSetLive(FALSE);
VideoCapSetOverlay(FALSE);

//-- Grab a frame -----------------------------------------------
capGrabFrameNoStop(G_hWndVideo);
}

//###############################################################
//	OnCapVideoSaveFrame()
//###############################################################
void	CVideoMainCWnd::OnCapVideoSaveFrame()
{
HINSTANCE		ghInstApp;
OPENFILENAME	ofn ;
char			achFileName[_MAX_PATH];
HRSRC			hFilter;
HGLOBAL			hResData;

achFileName[0] = 0;

ghInstApp=AfxGetInstanceHandle();

memset(&ofn, 0, sizeof(OPENFILENAME)) ;
ofn.lStructSize = sizeof(OPENFILENAME) ;
ofn.hwndOwner = m_hWnd ;

//load filters from resource stringtable

hFilter = ::FindResource(ghInstApp,
						 MAKEINTRESOURCE(ID_FILTER_DIB), RT_RCDATA);

if ( (hResData=::LoadResource(ghInstApp, hFilter)) == NULL) 
    ofn.lpstrFilter = NULL;
else 
	ofn.lpstrFilter =(char*) ::LockResource(hResData);

ofn.nFilterIndex = 1;
ofn.lpstrFile = achFileName;
ofn.nMaxFile = sizeof(achFileName);
ofn.lpstrFileTitle = NULL;
ofn.lpstrTitle = tmpString(IDS_TITLE_SAVEDIB);
ofn.nMaxFileTitle = 0;
ofn.lpstrInitialDir = NULL;
ofn.Flags =OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;


if (GetSaveFileName(&ofn)) 
	{
    // If the user has hit OK then set save file name
    capFileSaveDIB(G_hWndVideo, achFileName);
	}

if (hFilter) 
    UnlockResource(hFilter);

}

//###############################################################
//	OnCapVideoSaveFrame()
//###############################################################
LPSTR	CVideoMainCWnd::tmpString(UINT idString)
{
HINSTANCE		ghInstApp;
static char ach[350];

ghInstApp=AfxGetInstanceHandle();
LoadString(ghInstApp, idString, ach, sizeof(ach));

// ensure null terminated
ach[sizeof(ach) -1] = 0;

return(ach);
}

//###################################################################
//  FUNCTION   : TrackMouse(HWND hwnd, POINT pt)                     
//                                                                   
//  PURPOSE    : Draws a rubberbanding rectangle and displays it's   
//               dimensions till the mouse button is released                                                                          
//###################################################################
void CVideoMainCWnd::TrackMouse (HWND hwnd,POINTS pt)
{
//    MPOINT ptBase;
HDC   hdc;
MSG   msg;
POINTS ptOrigin;
RECT  rcClient;

hdc = ::GetDC(hwnd);
::SetCapture(hwnd);

::GetClientRect(hwnd,&rcClient);

/* Get mouse coordinates relative to origin of DIB */
ptOrigin.x = (short int)::GetScrollPos(hwnd,SB_HORZ);
ptOrigin.y = (short int)::GetScrollPos(hwnd,SB_VERT);

pt.x += ptOrigin.x;
pt.y += ptOrigin.y;

/* Display the coordinates */
(VOID)SetWindowOrgEx(hdc, ptOrigin.x, ptOrigin.y, NULL);
DrawSelect(hdc,FALSE);

/* Initialize clip rectangle to the point */
rcClip.left   = pt.x;
rcClip.top    = pt.y;
rcClip.right  = pt.x;
rcClip.bottom = pt.y;

/* Eat mouse messages until a WM_LBUTTONUP is encountered. Meanwhile
* continue to draw a rubberbanding rectangle and display it's dimensions
*/
for (;;)
	{
    WaitMessage();
    if (PeekMessage(&msg,NULL,WM_MOUSEFIRST,WM_MOUSELAST,PM_REMOVE))
		{
        DrawSelect(hdc,FALSE);

        rcClip.left   = pt.x;
        rcClip.top    = pt.y;
        rcClip.right  = LOWORD(msg.lParam) + ptOrigin.x;
        rcClip.bottom = HIWORD(msg.lParam) + ptOrigin.y;

        NormalizeRect(&rcClip);
        DrawSelect(hdc,TRUE);

        if (msg.message == WM_LBUTTONUP)
			{
			//ZoomToRect(rcClip);
            break;
			}
        }
    else
        continue;
    }

ZoomToRect(rcClip);
ReleaseCapture();
::ReleaseDC(hwnd,hdc);
}


//#################################################################
//  FUNCTION   :  DrawSelect(HDC hdc, BOOL fDraw)                           
//                                                                          
//  PURPOSE    :  Draws the selected clip rectangle with its dimensions on 
//                the DC/screen           
//#################################################################
VOID CVideoMainCWnd::DrawSelect( HDC hdc,BOOL fDraw )
{
    CHAR  sz[80];
    INT   x,y,len,dx,dy;
    HDC   hdcBits;
    HBITMAP hbm;

    if (!IsRectEmpty (&rcClip)) {

        /* If a rectangular clip region has been selected, draw it */
        PatBlt(hdc, rcClip.left,    rcClip.top,        rcClip.right-rcClip.left, 1,  DSTINVERT);
        PatBlt(hdc, rcClip.left,    rcClip.bottom, 1, -(rcClip.bottom-rcClip.top),   DSTINVERT);
        PatBlt(hdc, rcClip.right-1, rcClip.top, 1,   rcClip.bottom-rcClip.top,   DSTINVERT);
        PatBlt(hdc, rcClip.right,   rcClip.bottom-1, -(rcClip.right-rcClip.left), 1, DSTINVERT);

        /* Format the dimensions string ...*/
        sprintf( sz,
                  "%dx%d",
                  rcClip.right  - rcClip.left,
                  rcClip.bottom - rcClip.top );
     len = lstrlen(sz);

        /* ... and center it in the rectangle */
        { SIZE size;
        (VOID)GetTextExtentPoint(hdc, sz, len, &size);
        dx = size.cx; dy = size.cy;
        }
        x  =  (rcClip.right  + rcClip.left - dx) / 2;
        y  =  (rcClip.bottom + rcClip.top  - dy) / 2;

        hdcBits = CreateCompatibleDC (hdc);
        SetTextColor (hdcBits, 0xFFFFFFL);
        SetBkColor (hdcBits, 0x000000L);

        /* Output the text to the DC */
        /*if (hbm = +++CreateBitmap - Not Recommended(use CreateDIBitmap)+++ (dx, dy, 1, 1, NULL)){*/
        if (hbm = CreateBitmap(dx, dy, 1, 1, NULL))
			{
            hbm =(HBITMAP )SelectObject (hdcBits, hbm);
            ExtTextOut (hdcBits, 0, 0, 0, NULL, sz, len, NULL);
            BitBlt (hdc, x, y, dx, dy, hdcBits, 0, 0, SRCINVERT);
            hbm =(HBITMAP ) SelectObject (hdcBits, hbm);
            DeleteObject (hbm);
			}
        DeleteDC (hdcBits);
        UNREFERENCED_PARAMETER(fDraw);
    }
}

//################################################################## 
//  FUNCTION   : NormalizeRect(RECT *prc)                              
//                                                                    
//  PURPOSE    : If the rectangle coordinates are reversed, swaps them
//                                                                    
//##################################################################
void CVideoMainCWnd::NormalizeRect (RECT *prc)
{
    if (prc->right < prc->left)
        SWAP(prc->right,prc->left);
    if (prc->bottom < prc->top)
        SWAP(prc->bottom,prc->top);
}


//################################################################## 
//
//  FUNCTION   : OnParentNotify                              
//                                                                                                                                       
//##################################################################
void CVideoMainCWnd::OnParentNotify(UINT message, LPARAM lParam) 
{
	CWnd::OnParentNotify(message, lParam);
	
	if( message==WM_LBUTTONDOWN )
		{
		LPt=MAKEMPOINT(lParam);
		}
	else
		{
		if( message==WM_LBUTTONUP )
			RPt=MAKEMPOINT(lParam);
		}
	// TODO: Add your message handler code here
	
}

//################################################################## 
//
//  FUNCTION   : OnMouseActivate                              
//                                                                                                                                      
//##################################################################
int CVideoMainCWnd::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message) 
{
// TODO: Add your message handler code here and/or call default

if(MouseTracking==1)
	{
	if(message==WM_LBUTTONDOWN)
		{
		TrackMouse (G_hWndVideo,LPt);
		}
	}
return CWnd::OnMouseActivate(pDesktopWnd, nHitTest, message);

}

//################################################################## 
//
//  FUNCTION   : ZoomToRect()                            
//                                                                                                                                      
//##################################################################
void CVideoMainCWnd::ZoomToRect(RECT  rcClient)
{
// TODO: Add your message handler code here and/or call default
//CPreset::S_GotoPresetPoint(1);
RECT			rect;
unsigned char	Zoom[3]="\x0\x0";;
char			LByte,HByte;
unsigned char	LData,HData;
unsigned short 	ZoomValue;
char			Para[5];
int				Flag=0;
unsigned short 	PanAddr,TiltAddr;
POINTS			Window_Center,Client_Center,Pos_Vec,Step_Vec;
float			Ratio_x,Ratio_y;
unsigned int	Screen_X_Step=90,Screen_Y_Step=170;


//---- Request Zoom position --------
CComm::S_COM_RequestZoomFocus(Zoom);
LByte=Zoom[0];		HByte=Zoom[1];
ZoomValue=S_WORD(LByte,HByte);
//---- Request Attitude -------------
Flag=CComm::RequestAttitude(Para);
PanAddr=S_WORD(Para[0],Para[1]);
TiltAddr=S_WORD(Para[2],Para[3]);

//==== New position Algorithm =======
::GetWindowRect(m_hWnd,&rect);
Window_Center.x=( (rect.left+rect.right)/2 );
Window_Center.y=(rect.top+rect.bottom)/2-100;

Client_Center.x=(rcClient.left+rcClient.right)/2;
Client_Center.y=(rcClient.top+rcClient.bottom)/2;

Pos_Vec.x=Client_Center.x-Window_Center.x;
Pos_Vec.y=Client_Center.y-Window_Center.y;
Ratio_x=(float)( (rect.right-rect.left)/Pos_Vec.x );
Ratio_y=(float)( (rect.bottom-rect.top)/Pos_Vec.y );
Step_Vec.x=(short)(Screen_X_Step/Ratio_x);
Step_Vec.y=(short)(Screen_Y_Step/Ratio_y);

PanAddr=PanAddr+Step_Vec.x;
TiltAddr=TiltAddr-Step_Vec.y;


//---- Goto new Zoom position -------
//CComm::S_COM_ZoomTo(100);
//---- Goto new position of pan -----
S_WordTo2Bytes(PanAddr,&LData,&HData);
CComm::S_COM_PanTo(LData,HData);
//Sleep(50);
//---- Goto new position of Tilt ----
S_WordTo2Bytes(TiltAddr,&LData,&HData);
CComm::S_COM_TiltTo(LData,HData);

//sprintf(Disp,"Zoom(L)=%x Zoom(H)=%x ZoomValue=%x",LByte,HByte,ZoomValue);
//AfxMessageBox(Disp);
}
